var samplePageObj = {
  // 샘플 타이틀
  title: 'Context Menu 예제',
  subtitle: '시트의 내/외부에서 컨택스트 메뉴를 사용하는 방법을 알아봅니다.',

  // 샘플 설명
  desc: '시트의 내/외부에 마우스 좌/우측 클릭시 원하시는 메뉴를 구성하여 표시할 수 있습니다.<br>메뉴는 단일/복수 컬럼을 갖으며 다단계 형태로 구성도 가능합니다.<br>표시된 메뉴의 값을 선택하여 입력/수정 할 수 있습니다. ',

  // 객체 초기화 구문
  initStr:

  '{'
+ '\n  "Def": {'
+ '\n    "Col": {"RelWidth": 1},'
+ '\n  },'
+ '\n  "Cfg": {'
+ '\n    "SearchMode": 0'
+ '\n  },'
+ '\n  "LeftCols": ['
+ '\n    {"Header": "No", "Name": "SEQ", "Visible": true}'
+ '\n  ],'
+ '\n  "Cols": ['
+ '\n    {"Header": "이름","Name": "sName","Type": "Text", "Align": "Center"},'
+ '\n    {"Header": "아이디","Name": "sId","Type": "Text","RelWidth": 2},'
+ '\n    {"Header": "회사","Name": "sCompany","Type": "Text","Align": "Center","Tip": "마우스 오른쪽 버튼으로 메뉴호출",Color:"#EAFADD",'
+ '\n      "Menu": {'
+ '\n        "Items": ['
+ '\n          { "Name": "일반", "Caption": 1 },'
+ '\n          { "Name": "한화" },'
+ '\n          { "Name": "현대" },'
+ '\n          {'
+ '\n            "Columns": 2,'
+ '\n            "Items": ['
+ '\n              { "Name": "SK" },'
+ '\n              { "Name": "은행", "Menu": 1,'
+ '\n                "Items": ['
+ '\n                  { "Name": "하나은행" },'
+ '\n                  { "Name": "신한은행" },'
+ '\n                ]'
+ '\n              },'
+ '\n              { "Name": "롯데" },'
+ '\n              { "Name": "전자", "Menu": 1,'
+ '\n                "Items": ['
+ '\n                  { "Name": "삼성전자" },'
+ '\n                  { "Name": "엘지전자" },'
+ '\n                ]'
+ '\n              },'
+ '\n            ]'
+ '\n          },'
+ '\n          { "Name": "현대기아" },'
+ '\n          { "Name": "-" },'
+ '\n          { "Name": "본사", "Menu": 1,'
+ '\n            "Items": ['
+ '\n              { "Name": "IB" },'
+ '\n              { "Name": "IB2" },'
+ '\n            ]'
+ '\n          },'
+ '\n          { "Name": "공공", "Caption": 1 },'
+ '\n          { "Name": "식약청" },'
+ '\n          { "Name": "기상청/공항", "Level": 1, "Expanded": 0,'
+ '\n            "Items": ['
+ '\n              { "Name": "인천공항" },'
+ '\n              { "Name": "부산공항" },'
+ '\n              { "Name": "제주공항" },'
+ '\n            ]'
+ '\n          },'
+ '\n          { "Name": "공사", "Level": 1, "Expanded": 0,'
+ '\n            "Items": ['
+ '\n              { "Name": "철도공사" },'
+ '\n              { "Name": "주택공사" },'
+ '\n            ]'
+ '\n          }'
+ '\n        ]'
+ '\n      }'
+ '\n    },'
+ '\n    {"Header": "부서","Name": "sDepartment","Type": "Text","Menu": "|경영지원팀|총무부서|영업팀|구매팀|전산팀|마케팅|인사",Align: "Center","Tip": "마우스 오른쪽 버튼으로 메뉴호출","Color":"#EAFADD"},'
+ '\n    {"Header": "외국어","Name": "sLanguage","Type": "Text","RelWidth": 2,"Tip": "마우스 <b style="color:red">왼쪽</b> 버튼으로 메뉴호출","OnClick": "showLanguageMenu(Sheet, Row, Col)","Color":"#EAFADD"},'
+ '\n    {"Header": "주소","Name": "sAddr","Type": "Text","RelWidth": 5},'
+ '\n    {"Header": "sMoney","Name": "sMoney","Type": "Text","RelWidth": 5,"Visible": 0},'
+ '\n    {"Header": "sComment","Name": "sComment","Type": "Text","RelWidth": 5,"Visible": 0}'
+ '\n  ]'
+ '\n}',

  // 객체 초기화 구문
  init: {
    Def: {
      Col: { RelWidth: 1 },
    },
    Cfg: {
      SearchMode: 0
    },
    LeftCols: [
      {
        Header: 'No',
        Name: 'SEQ',
        Visible: true
      }
    ],
    Cols: [
      {
        Header: '이름',
        Name: 'sName',
        Type: 'Text',
        Align: 'Center'
      },
      {
        Header: '아이디',
        Name: 'sId',
        Type: 'Text',
        RelWidth: 2
      },
      {
        Header: '회사',
        Name: 'sCompany',
        Type: 'Text',
        Align: 'Center',
        Tip: '마우스 오른쪽 버튼으로 메뉴호출',
        Color: '#EAFADD',
        Menu: {
          Items: [
            {
              Name: '일반',
              Caption: 1
            },
            { Name: '한화' },
            { Name: '현대' },
            {
              Columns: 2,
              Items: [
                { Name: 'SK' },
                {
                  Name: '은행',
                  Menu: 1,
                  Items: [
                    { Name: '하나은행' },
                    { Name: '신한은행' },
                  ]
                },
                { Name: '롯데' },
                {
                  Name: '전자',
                  Menu: 1,
                  Items: [
                    { Name: '삼성전자' },
                    { Name: '엘지전자' },
                  ]
                },
              ]
            },
            { Name: '현대기아' },
            { Name: '-' },
            {
              Name: '본사',
              Menu: 1,
              Items: [
                { Name: 'IB' },
                { Name: 'IB2' },
              ]
            },
            {
              Name: '공공',
              Caption: 1
            },
            { Name: '식약청' },
            {
              Name: '기상청/공항',
              Level: 1,
              Expanded: 0,
              Items: [
                { Name: '인천공항' },
                { Name: '부산공항' },
                { Name: '제주공항' },
              ]
            },
            {
              Name: '공사',
              Level: 1,
              Expanded: 0,
              Items: [
                { Name: '철도공사' },
                { Name: '주택공사' },
              ]
            }
          ]
        }
      },
      {
        Header: '부서',
        Name: 'sDepartment',
        Type: 'Text',
        Menu: '|경영지원팀|총무부서|영업팀|구매팀|전산팀|마케팅|인사',
        Align: 'Center',
        Tip: '마우스 오른쪽 버튼으로 메뉴호출',
        Color: '#EAFADD'
      },
      {
        Header: '외국어',
        Name: 'sLanguage',
        Type: 'Text',
        RelWidth: 2,
        Tip: '마우스 <b style="color:red">왼쪽</b> 버튼으로 메뉴호출',
        OnClick: 'samplePageObj.externalFunction.showLanguageMenu(Sheet, Row, Col)',
        Color: '#EAFADD'
      },
      {
        Header: '주소',
        Name: 'sAddr',
        Type: 'Text',
        RelWidth: 5
      },
      {
        Header: 'sMoney',
        Name: 'sMoney',
        Type: 'Text',
        RelWidth: 5,
        Visible: 0
      },
      {
        Header: 'sComment',
        Name: 'sComment',
        Type: 'Text',
        RelWidth: 5,
        Visible: 0
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><strong style=\'width: 280px;\' class=\'mgr30\'>마우스 <span style=\'color:red;vertical-align: baseline;\'>&nbsp;왼쪽&nbsp;</span> 버튼으로 Context 메뉴 호출 </strong><input type=\'text\' size="40"  id=\'contextMenuInput\' class=\'mgr10\' title=\'마우스 왼쪽 버튼으로 Context 메뉴 호출\'/></div><hr>'
      + '<div><strong style=\'width: 280px;\' class=\'mgr30\'>마우스 <span style=\'color:red;vertical-align: baseline;\'>&nbsp;오른쪽&nbsp;</span> 버튼으로 Context 메뉴 호출 </strong><input type=\'text\' size="40" id=\'contextMenuInputTwo\' class=\'mgr10\' title=\'마우스 오른쪽 버튼으로 Context 메뉴 호출\' /></div><hr>'
      + '<div><strong style=\'width: 280px;\' class=\'mgr30\'>마우스 <span style=\'color:red;vertical-align: baseline;\'>&nbsp;양쪽&nbsp;</span> 버튼으로 Context 메뉴 호출 </strong><input type=\'text\' size="40" id=\'contextMenuInputThree\' class=\'mgr10\' title=\'마우스 양쪽 버튼으로 Context 메뉴 호출\'/></div><hr>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function (obj) {

  },
  externalFunction: {
    showLanguageMenu: function (sheet, row, col) {
      sheet.endEdit(1);
      sheet.focus({
        row: row,
        col: col
      });
      var menuOptions = {
        OnSave: function (item, values) {
          var val = values.join(',');

          sheet.setValue(row, col, val, true);
        },
        Default: { Bool: true },
        Items: [
          {
            Name: '아시아/중동',
            Caption: true
          },
          { Name: '일본어' },
          { Name: '중국어' },
          { Name: '아랍어' },
          {
            Name: '유럽',
            Caption: true
          },
          {
            Columns: 2,
            Bool: false,
            Items: [
              {
                Name: '프랑스어',
                Bool: true
              },
              {
                Name: '독일어',
                Bool: true
              },
              {
                Name: '기타',
                Bool: false,
                Menu: true,
                Items: [
                  {
                    Name: '스위스어',
                    Bool: true
                  },
                  {
                    Name: '그리스어',
                    Bool: true
                  },
                  {
                    Name: '터키어',
                    Bool: true
                  }
                ]
              },
              {
                Name: '스페인어',
                Bool: true
              },
              {
                Name: '러시아어',
                Bool: true
              },
            ]
          },
          {
            Name: '영미권',
            Caption: true
          },
          { Name: '영어' }

        ],
        Buttons: ['ok']
      };
      var pos = { Align: 'right below' };
      var initValues = sheet.getValue(row, col).split(',');

      sheet.showMenu(row, col, menuOptions, pos, null, initValues);

      return true;
    }
  },
  // event구문
  event: {
    onRenderFirstFinish: function (evtParam) {
      var contextMenuInput = document.getElementById('contextMenuInput');
      var contextMenuInputTwo = document.getElementById('contextMenuInputTwo');
      var contextMenuInputThree = document.getElementById('contextMenuInputThree');
      var pos;
      var menu;

      // case 1 event
      contextMenuInput.addEventListener('click', function (event) {
        event.preventDefault();

        pos = { Tag: 'contextMenuInput' };

        menu = {
          Items: [
            {
              Name: '경영지원팀',
              Text: '경영지원팀'
            },
            {
              Name: '총무부서',
              Text: '총무부서'
            },
            {
              Name: '영업팀',
              Text: '영업팀'
            },
            {
              Name: '구매팀',
              Text: '구매팀'
            },
            {
              Name: '전산팀',
              Text: '전산팀'
            },
            {
              Name: '마케팅',
              Text: '마케팅'
            },
            {
              Name: '인사',
              Text: '인사'
            }
          ],
          Default: {
            OnClick: function (item, data) {
              contextMenuInput.value = data.Text;
            }
          },

        };

        IBSheet.showMenu(menu, pos, null);
      });

      // case 2 event
      contextMenuInputTwo.addEventListener('contextmenu', function (event) {
        event.preventDefault();

        pos = { Tag: 'contextMenuInputTwo' };

        menu = {
          Default: { Bool: true },
          Items: [
            {
              Name: '아시아/중동',
              Caption: true
            },
            { Name: '일본어' },
            { Name: '중국어' },
            { Name: '아랍어' },
            {
              Name: '유럽',
              Caption: true
            },
            {
              Columns: 2,
              Bool: false,
              Items: [
                {
                  Name: '프랑스어',
                  Bool: true
                },
                {
                  Name: '독일어',
                  Bool: true
                },
                {
                  Name: '기타',
                  Bool: false,
                  Menu: true,
                  Items: [
                    {
                      Name: '스위스어',
                      Bool: true
                    },
                    {
                      Name: '그리스어',
                      Bool: true
                    },
                    {
                      Name: '터키어',
                      Bool: true
                    }
                  ]
                },
                {
                  Name: '스페인어',
                  Bool: true
                },
                {
                  Name: '러시아어',
                  Bool: true
                },
              ]
            },
            {
              Name: '영미권',
              Caption: true
            },
            { Name: '영어' }

          ],
          Buttons: ['ok']
        };

        IBSheet.showMenu(menu, pos, function (item, values) {
          contextMenuInputTwo.value = values.join(',');
        });
      });

      // case 3 click event
      contextMenuInputThree.addEventListener('click', function (event) {
        event.preventDefault();

        pos = { Tag: 'contextMenuInputThree' };

        menu = {
          Items: [
            {
              Name: '일반',
              Caption: 1
            },
            { Name: '한화' },
            { Name: '현대' },
            {
              Columns: 2,
              Items: [
                { Name: 'SK' },
                {
                  Name: '은행',
                  Menu: 1,
                  Items: [
                    { Name: '하나은행' },
                    { Name: '신한은행' },
                  ]
                },
                { Name: '롯데' },
                {
                  Name: '전자',
                  Menu: 1,
                  Items: [
                    { Name: '삼성전자' },
                    { Name: '엘지전자' },
                  ]
                },
              ]
            },
            { Name: '현대기아' },
            { Name: '-' },
            {
              Name: '본사',
              Menu: 1,
              Items: [
                { Name: 'IB' },
                { Name: 'IB2' },
              ]
            },
            {
              Name: '공공',
              Caption: 1
            },
            { Name: '식약청' },
            {
              Name: '기상청/공항',
              Level: 1,
              Expanded: 0,
              Items: [
                { Name: '인천공항' },
                { Name: '부산공항' },
                { Name: '제주공항' },
              ]
            },
            {
              Name: '공사',
              Level: 1,
              Expanded: 0,
              Items: [
                { Name: '철도공사' },
                { Name: '주택공사' },
              ]
            }
          ]
        };

        IBSheet.showMenu(menu, pos, function (item, values) {
          contextMenuInputThree.value = item.Name;
        });
      });

      // case 3 contextmenu event
      contextMenuInputThree.addEventListener('contextmenu', function (event) {
        event.preventDefault();

        pos = { Tag: 'contextMenuInputThree' };

        menu = {
          Items: [
            {
              Name: '일반',
              Caption: 1
            },
            { Name: '한화' },
            { Name: '현대' },
            {
              Columns: 2,
              Items: [
                { Name: 'SK' },
                {
                  Name: '은행',
                  Menu: 1,
                  Items: [
                    { Name: '하나은행' },
                    { Name: '신한은행' },
                  ]
                },
                { Name: '롯데' },
                {
                  Name: '전자',
                  Menu: 1,
                  Items: [
                    { Name: '삼성전자' },
                    { Name: '엘지전자' },
                  ]
                },
              ]
            },
            { Name: '현대기아' },
            { Name: '-' },
            {
              Name: '본사',
              Menu: 1,
              Items: [
                { Name: 'IB' },
                { Name: 'IB2' },
              ]
            },
            {
              Name: '공공',
              Caption: 1
            },
            { Name: '식약청' },
            {
              Name: '기상청/공항',
              Level: 1,
              Expanded: 0,
              Items: [
                { Name: '인천공항' },
                { Name: '부산공항' },
                { Name: '제주공항' },
              ]
            },
            {
              Name: '공사',
              Level: 1,
              Expanded: 0,
              Items: [
                { Name: '철도공사' },
                { Name: '주택공사' },
              ]
            }
          ]
        };

        IBSheet.showMenu(menu, pos, function (item, values) {
          contextMenuInputThree.value = item.Name;
        });
      });
    },
    onSelectMenu: function (evtParam) {
      var sheet = evtParam.sheet;
      var row = evtParam.row;
      var col = evtParam.col;
      var val = evtParam.result;

      if (row.Kind === 'Header') { return; }

      // 부서 컬럼에서 드레그한 영역에 값을 모두 같은 값으로 변경하는 로직
      if (evtParam.col === 'sDepartment') {
        var colsArr = evtParam.sheet.getCols();
        // 드레그 선택된 영역 전체의 값을 수정하자.
        var selectArea = evtParam.sheet.getSelectedRanges(0, 0);

        if (selectArea.length > 0) {
          // 선택된 부분 중에 sDepartment 컬럼이 포함된 곳을 찾아 변경한다.
          for (var r = 0; r < selectArea.length; r++) {
            // 시작열 인덱스
            var startColIdx = colsArr.indexOf(selectArea[r][1]);
            var endColIdx = colsArr.indexOf(selectArea[r][3]);
            var newArr = colsArr.slice(startColIdx, endColIdx + 1);

            // 시작과 끝 사이에 sDepartment가 있는지 찾자.
            if (newArr.indexOf('sDepartment') > -1) {
              var rrr = selectArea[r][0];

              for (var cnt = 0; cnt < selectArea[r][6]; cnt++) {
                sheet.setValue(rrr, 'sDepartment', val);
                rrr = sheet.getNextRow(rrr);
              }
              sheet.renderBody();
            }
          }
        } else {
          sheet.setValue(row, col, val);
        }
      } else {
        sheet.setValue(row, col, val);
      }
    }
  },

  // data
  data: [
    {
      sName: '황정열',
      sMoney: '5000',
      sComment: '코멘트를 입력해주세요',
      sId: '801221384251',
      sAddr: '서울특별시 구로구 가리봉동',
      sCompany: '한화',
      sDepartment: '인사',
      sLanguage: '영어'
    },
    {
      sName: '강대호',
      sMoney: '4700',
      sComment: '코멘트를 입력해주세요',
      sId: '807151852148',
      sAddr: '경기도 남양주시 도농동',
      sDepartment: '경영지원',
      sCompany: 'SK',
      sLanguage: '영어,일본어'
    },
    {
      sName: '김미경',
      sMoney: '3900',
      sComment: '코멘트를 입력해주세요',
      sId: '138206820',
      sAddr: '강원도 강릉시 강동면 모전리',
      sDepartment: '총무부서',
      sCompany: '현대',
      sLanguage: '영어'
    },
    {
      sName: '김선희',
      sMoney: '3400',
      sComment: '코멘트를 입력해주세요',
      sId: '6098204963',
      sAddr: '경기도 성남시 수정구 금토동',
      sDepartment: '영업팀',
      sCompany: '롯데',
      sLanguage: '영어,중국어'
    },
    {
      sName: '최세희',
      sMoney: '3200',
      sComment: '코멘트를 입력해주세요',
      sId: '405142384211',
      sAddr: '경기도 광주시 오포읍 신현리',
      sDepartment: '영업팀',
      sCompany: '현대기아',
      sLanguage: '영어,러시아어'
    },
    {
      sName: '이명희',
      sMoney: '2900',
      sComment: '코멘트를 입력해주세요',
      sId: '801221384251',
      sAddr: '경기도 수원시 권선구 고색동',
      sDepartment: '구매팀',
      sCompany: '식약청',
      sLanguage: '독일어,프랑스어'
    },
    {
      sName: '노효일',
      sMoney: '2300',
      sComment: '코멘트를 입력해주세요',
      sId: '506243051223',
      sAddr: '서울시 강남구 양재대로 55길10',
      sDepartment: '마케팅',
      sCompany: '인천공항',
      sLanguage: '영어'
    },
    {
      sName: '원영국',
      sMoney: '2800',
      sComment: '코멘트를 입력해주세요',
      sId: '2118204825',
      sAddr: '경기도 광주시 오포읍 신현리',
      sDepartment: '인사',
      sCompany: '제주공항',
      sLanguage: '영어,일본어'
    },
    {
      sName: '이지선',
      sMoney: '2400',
      sComment: '코멘트를 입력해주세요',
      sId: '1298261319',
      sAddr: '서울시 강남구 양재대로 55길10',
      sDepartment: '전산팀',
      sCompany: '부산공항',
      sLanguage: '영어'
    },
    {
      sName: '김상도',
      sMoney: '4000',
      sComment: '코멘트를 입력해주세요',
      sId: '507142063425',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '영업팀',
      sCompany: '삼성전자',
      sLanguage: '스페인어'
    },
    {
      sName: '한보라',
      sMoney: '2800',
      sComment: '코멘트를 입력해주세요',
      sId: '2098200597',
      sAddr: '서울시 강남구 양재대로 55길10',
      sDepartment: '영업팀',
      sCompany: '엘지전자',
      sLanguage: '영어,아랍어'
    },
    {
      sName: '장태우',
      sMoney: '2800',
      sComment: '코멘트를 입력해주세요',
      sId: '5068272842',
      sAddr: '경상북도 안동시 강남동',
      sDepartment: '구매팀',
      sCompany: '본사',
      sLanguage: '영어'
    },
    {
      sName: '정필석',
      sMoney: '4000',
      sComment: '코멘트를 입력해주세요',
      sId: '1298263035',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '전산팀',
      sCompany: '한화',
      sLanguage: '영어,그리스어'
    },
    {
      sName: '조성목',
      sMoney: '4100',
      sComment: '코멘트를 입력해주세요',
      sId: '410102263574',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '마케팅',
      sCompany: '신한은행',
      sLanguage: '영어,스페인어'
    },
    {
      sName: '유봉근',
      sMoney: '4200',
      sComment: '코멘트를 입력해주세요',
      sId: '4098272390',
      sAddr: '전라북도 전주시 덕진구 강흥동',
      sDepartment: '구매팀',
      sCompany: '하나은행',
      sLanguage: '영어'
    },
    {
      sName: '오필환',
      sMoney: '3700',
      sComment: '코멘트를 입력해주세요',
      sId: '2118208651',
      sAddr: '경기도 수원시 권선구 고색동',
      sDepartment: '영업팀',
      sCompany: '롯데',
      sLanguage: '영어,중국어'
    },
    {
      sName: '송복석',
      sMoney: '3900',
      sComment: '코멘트를 입력해주세요',
      sId: '703301678921',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '경영지원팀',
      sCompany: '인천공항',
      sLanguage: '영어,중국어,일본어'
    },
    {
      sName: '김남연',
      sMoney: '3600',
      sComment: '코멘트를 입력해주세요',
      sId: '206232384536',
      sAddr: '서울시 강남구 논현동',
      sDepartment: '마케팅',
      sCompany: 'SK',
      sLanguage: '영어'
    },
    {
      sName: '한혜선',
      sMoney: '2900',
      sComment: '코멘트를 입력해주세요',
      sId: '1298261319',
      sAddr: '서울시 강남구 논현동',
      sDepartment: '전산팀',
      sCompany: '삼성전자',
      sLanguage: '영어'
    },
    {
      sName: '조미미',
      sMoney: '2500',
      sComment: '코멘트를 입력해주세요',
      sId: '1108264699',
      sAddr: '서울시 강남구 논현동',
      sDepartment: '영업팀',
      sCompany: '한화',
      sLanguage: '영어'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
